IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_EST_SNGPC_EXTRATO]') AND type in (N'P', N'PC'))
	DROP PROCEDURE [dbo].[P_EST_PROD_EST_SNGPC_EXTRATO]
GO

CREATE PROCEDURE [DBO].[P_EST_PROD_EST_SNGPC_EXTRATO](@CD_EMP    INT
													, @CD_FILIAL INT
													, @CD_PROD   INT  = 0
													, @DT_INI    DATE
													, @DT_FIM    DATE)
AS
	 BEGIN
		 SET NOCOUNT ON;
		 CREATE TABLE #RS_EXTRATO
		 (ORDEM          INT IDENTITY(1, 1)
		, NOTACUPON      INT NULL
		, TP_MOV         VARCHAR(30)
		, MOV            VARCHAR(30)
		, DT_MOV         DATETIME
		, CD_MOV         INT
		, DS_MOV         VARCHAR(150)
		, CD_PROD        INT
		, DS_PROD        VARCHAR(200)
		, CD_LOTE        INT
		, NR_LOTE        VARCHAR(30)
		, QT_MOV         INT
		, SALDO_LOTE     INT
		, SALDO_ANTERIOR INT
		, SALDO_FINAL    INT
        , NR_RECEITA     BIGINT
		 );
		 DECLARE
				@SALDO_ANTERIOR INT;
		 DECLARE
				@SALDO_FINAL INT;
		 DECLARE
				@SALDO_LOTE INT;
		 DECLARE
				@MOV VARCHAR(30);
		 DECLARE
				@CD_MOV INT;
		 DECLARE
				@QT_MOV INT;
		 DECLARE
				@DT_MOV DATETIME;
		 DECLARE
				@CUR_CD_PROD INT;
		 DECLARE
				@OLD_CD_PROD INT;
		 DECLARE
				@OLD_CD_LOTE INT;
		 DECLARE
				@CD_LOTE INT;
		 DECLARE
				@ORDEM INT; 
                
        DECLARE
				@NR_RECEITA BIGINT;        
		 -------------------------------------------------------------------------------
		 ------------------------------------------------------------------------------
		 INSERT INTO #RS_EXTRATO
				SELECT NOTA_CUPOM
					 , TP_MOV
					 , MOV
					 , DT_MOV
					 , CD_MOV
					 , MOTIVO
					 , CD_PROD
					 , DS_PROD
					 , CD_LOTE
					 , NR_LOTE
					 , QT_LOTE
					 , SALDO_ATUAL
					 , 0
					 , 0
                     , NR_RECEITA
				FROM V_SNGPC_MOVIMENTACOES
				WHERE CD_EMP = @CD_EMP
					  AND CD_FILIAL = @CD_FILIAL
					  AND CD_PROD = CASE
										WHEN @CD_PROD = 0
										THEN CD_PROD
										ELSE @CD_PROD
									END
					  AND DT_MOV BETWEEN @DT_INI AND @DT_FIM
				ORDER BY CD_PROD
					   , CD_LOTE
					   , DT_MOV DESC
					   , CD_MOV DESC; 
		 --------------------------------------------------------------------------------
		 --   CURSOR  OPERATION BELOW 
		 --
		 --------------------------------------------------------------------------------
		 DECLARE CALCESTOQUE CURSOR FAST_FORWARD
		 FOR SELECT ORDEM
				  , CD_PROD
				  , CD_LOTE
				  , DT_MOV
				  , CD_MOV
				  , MOV
				  , QT_MOV
				  , SALDO_LOTE
                  , NR_RECEITA
			 FROM #RS_EXTRATO
			 ORDER BY ORDEM;
		 OPEN CALCESTOQUE;
		 FETCH NEXT FROM CALCESTOQUE INTO
										  @ORDEM
										, @CUR_CD_PROD
										, @CD_LOTE
										, @DT_MOV
										, @CD_MOV
										, @MOV
										, @QT_MOV
										, @SALDO_LOTE
                                        , @NR_RECEITA
                                        ;
		 SET @OLD_CD_LOTE = 0;
		 SET @SALDO_ANTERIOR = 0;
		 SET @OLD_CD_LOTE = 0;
		 SET @SALDO_FINAL = 0;
		 WHILE @@FETCH_STATUS = 0
			 BEGIN
				 SET @SALDO_FINAL = 0;
				 -- PRINT 'CONSULTANDO DATA '+ CAST( @DT_MOV AS VARCHAR(MAX))
				 IF(@OLD_CD_LOTE <> @CD_LOTE)
					 BEGIN
						 -- PRINT 'SETANDO LOTE '+    CAST( @SALDO_LOTE AS VARCHAR(MAX))
						 SET @SALDO_ANTERIOR = @SALDO_LOTE;
					 END;
				 SET @OLD_CD_PROD = @CD_LOTE;
				 SET @OLD_CD_LOTE = @CD_LOTE;
				 IF UPPER(@MOV) = 'ENTRADAS'
					 BEGIN
						 SET @SALDO_ANTERIOR = ISNULL((@SALDO_ANTERIOR - @QT_MOV), 0);
						 SET @SALDO_FINAL = ISNULL((@SALDO_ANTERIOR + @QT_MOV), 0);
					 END;
				 IF UPPER(@MOV) = 'SAIDAS'
					 BEGIN
						 SET @SALDO_ANTERIOR = ISNULL((@SALDO_ANTERIOR + @QT_MOV), 0);
						 SET @SALDO_FINAL = ISNULL((@SALDO_ANTERIOR - @QT_MOV), 0);
					 END;
				 --PRINT 'SETANDO SALDO '+  CAST(  @SALDO_ANTERIOR AS VARCHAR(MAX))
				 UPDATE #RS_EXTRATO
				   SET
					   SALDO_ANTERIOR = ISNULL(@SALDO_ANTERIOR, 0)
					 , SALDO_FINAL = ISNULL(@SALDO_FINAL, 0)
				 WHERE ORDEM = @ORDEM;
				 FETCH NEXT FROM CALCESTOQUE INTO
												  @ORDEM
												, @CUR_CD_PROD
												, @CD_LOTE
												, @DT_MOV
												, @CD_MOV
												, @MOV
												, @QT_MOV
												, @SALDO_LOTE
                                                , @NR_RECEITA
                                                
                                                
                                                ;
                                                
			 END; 
		 --FECHANDO CURSOS 
		 CLOSE CALCESTOQUE; 
		 --DESALOCANDO CURSOS DA MEMORIA 
		 DEALLOCATE CALCESTOQUE;
		 SELECT A.NOTACUPON
			  , A.DS_MOV
			  , A.CD_PROD
			  , A.DS_PROD
			  , A.TP_MOV
			  , A.MOV
			  , A.DT_MOV
			  , A.CD_MOV
			  , A.CD_LOTE
			  , A.NR_LOTE
			  , A.SALDO_ANTERIOR
			  , A.QT_MOV
			  , A.SALDO_FINAL
			  , SALDO_LOTE
              , NR_RECEITA
			  , U.NM_USU
			  , H.VERSAO
		 FROM #RS_EXTRATO AS A
			  LEFT JOIN SNGPC_HIST_MOV_LOTE H ON H.CD_EMP = @CD_EMP
												 AND H.CD_FILIAL = @CD_FILIAL
												 AND H.CD_MOV = A.CD_MOV
												 AND H.LOTE = CAST(A.CD_LOTE AS VARCHAR(30))
			  LEFT JOIN GLB_USU U ON U.CD_USU = H.CD_USU
		 ORDER BY CD_PROD
				, DT_MOV DESC
				, CD_MOV DESC
				, CD_LOTE;
		 RETURN;
		 DROP TABLE #RS_MOV;
		 DROP TABLE #RS_EXTRATO;
	 END;
GO